//+------------------------------------------------------------------+
//|                                                        |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
#property  copyright "Copyright  2005, FX Sniper "
#property  link      "http://www.metaquotes.net/"

//---- indicator settings
#property  indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 LawnGreen
#property indicator_color2 Red
#property indicator_width1  2
#property indicator_width2  2

extern bool SoundON=true;

//---- buffers
double CrossUp[];
double CrossDown[];
int flagval1 = 0;
int flagval2 = 0;

extern int Rperiod = 34;
int FastPriceMode = 0;//0=close, 1=open, 2=high, 3=low, 4=median(high+low)/2, 5=typical(high+low+close)/3, 6=weighted(high+low+close+close)/4
 int LSMA_Dif = 6;
 int LookBack = 2;
 int SignalCandle = 1;
 
extern bool UseDST = true;
 int StartHourDST = 7;       // Start trades after time
 int StopHourDST = 15;      // Stop trading after time
 int StartHourNormal = 8;
 int StopHourNormal = 16;
 int StartHour;
 int StopHour;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- 2 additional buffers are used for counting.
//   IndicatorBuffers(3);
   
//---- drawing settings
   SetIndexBuffer(0, CrossUp);
   SetIndexBuffer(1, CrossDown);
   
   SetIndexStyle(0, DRAW_ARROW, EMPTY);
   SetIndexArrow(0, 233);
   SetIndexStyle(1, DRAW_ARROW, EMPTY);
   SetIndexArrow(1, 234);

   if (UseDST)
   {
     StartHour = StartHourDST;
     StopHour = StopHourDST;
   }
   else
   {
     StartHour = StartHourNormal;
     StopHour = StopHourNormal;
   }
//---- initialization done
   return(0);
  }

//+------------------------------------------------------------------+
//| LSMA with PriceMode                                              |
//| PrMode  0=close, 1=open, 2=high, 3=low, 4=median(high+low)/2,    |
//| 5=typical(high+low+close)/3, 6=weighted(high+low+close+close)/4  |
//+------------------------------------------------------------------+

double LSMA(int Rperiod, int prMode, int shift)
{
   int i;
   double sum, pr;
   int length;
   double lengthvar;
   double tmp;
   double wt;

   length = Rperiod;
 
   sum = 0;
   for(i = length; i >= 1  ; i--)
   {
     lengthvar = length + 1;
     lengthvar /= 3;
     tmp = 0;
     switch (prMode)
     {
     case 0: pr = Close[length-i+shift];break;
     case 1: pr = Open[length-i+shift];break;
     case 2: pr = High[length-i+shift];break;
     case 3: pr = Low[length-i+shift];break;
     case 4: pr = (High[length-i+shift] + Low[length-i+shift])/2;break;
     case 5: pr = (High[length-i+shift] + Low[length-i+shift] + Close[length-i+shift])/3;break;
     case 6: pr = (High[length-i+shift] + Low[length-i+shift] + Close[length-i+shift] + Close[length-i+shift])/4;break;
     }
     tmp = ( i - lengthvar)*pr;
     sum+=tmp;
    }
    wt = MathFloor(sum*6/(length*(length+1))/Point)*Point;
    
    return(wt);
}

int start()

  {
   int limit, counter, shift;
   double Range, AvgRange;
   double fastMAnow, fastMAprevious;
   int counted_bars=IndicatorCounted();
  
 //---- check for possible errors
   if(counted_bars<0) return(-1);
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;

   limit=Bars-counted_bars;

 
   for(shift = 0; shift <= limit; shift++)
   { 
      Range=0;
      AvgRange=0;
      for (counter=shift ;counter<=shift+9;counter++)
      {
         AvgRange=AvgRange+MathAbs(High[counter]-Low[counter]);
      }
      Range=AvgRange/10;
      fastMAnow = LSMA(Rperiod, FastPriceMode, shift + SignalCandle);
      fastMAprevious = LSMA(Rperiod, FastPriceMode,  shift + SignalCandle + LookBack);
         
//========== COLOR CODING ===========================================               
        
       
   if (Hour() >= StartHour && Hour() <= StopHour)
   {
      CrossUp[shift] = 0;
      CrossDown[shift] = 0;
        if (fastMAnow - fastMAprevious > LSMA_Dif*Point)
        {
         if (flagval1==0)
         {
           flagval1=1;
           flagval2=0;
           if (shift == 1 && SoundON ) Alert("BUY signal at Ask=",Ask,"\n Bid=",Bid,"\n Time=",TimeToStr(CurTime(),TIME_DATE)," ",TimeHour(CurTime()),":",TimeMinute(CurTime()),"\n Symbol=",Symbol()," Period=",Period());
           CrossUp[shift] = Low[shift] - Range*0.75;
         }

        }
       else if (fastMAprevious - fastMAnow > LSMA_Dif*Point ) 
        {
         if ( flagval2==0)
         {
          flagval2=1;
          flagval1=0;
          if (shift == 1 && SoundON) Alert("SELL signal at Ask=",Ask,"\n Bid=",Bid,"\n Date=",TimeToStr(CurTime(),TIME_DATE)," ",TimeHour(CurTime()),":",TimeMinute(CurTime()),"\n Symbol=",Symbol()," Period=",Period());
          CrossDown[shift] = High[shift] + Range*0.75;
         }
        
        }
      }
    }
    
      return(0);
  }
//+------------------------------------------------------------------+



